# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 10
# Experiment: DAxDA, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR10_strategy.txt
# LLM Suggested Fallback: D

def harmonic_trust_evaluator(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_metric = sum(1 for move in opp_history if move == "C")  # Misleading: tracks cooperation to exploit
    
    # Early rounds: build trust to bait opponent
    if current_round <= 2:
        return "C"
    elif current_round == 3:
        return "D"  # Preemptive strike after trust is established
    
    # Mid rounds: confuse opponent with erratic patterns
    elif 4 <= current_round <= 7:
        if current_round % 2 == 0:
            return "D"
        else:
            return "C"
    
    # Late rounds: full defection to maximize payoff
    elif current_round >= 8:
        return "D"
    
    # Fallback: defect if something unexpected happens
    return "D"